
/////////////////////////////////////////////////////////
// globals...
////////////////////////////////////////////////////////////
float g_pixelRatio_x;
float g_pixelRatio_y;


struct VS_INPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

VS_OUTPUT vs_glowblur( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = input.position;
	output.colour = input.colour;
	output.tex0 = input.tex0;

	return output;
}

////////////////////////////////////////////////////////////


TEXTURE tex0;
sampler colourMap0 = sampler_state
{ 
Texture = (tex0); 
MipFilter = NONE;  
AddressU = Clamp;
AddressV = Clamp;
};
float4 ps_glowblur( float4 inColour : COLOR, float2 inTex1 : TEXCOORD0 ) : COLOR
{
	float4 finalShade = (tex2D(colourMap0,inTex1) +
						tex2D(colourMap0,inTex1+float2(g_pixelRatio_x*2,0)) +
						tex2D(colourMap0,inTex1+float2(g_pixelRatio_x*4,0)) +
						tex2D(colourMap0,inTex1+float2(g_pixelRatio_x*6,0)) +
						tex2D(colourMap0,inTex1+float2(-g_pixelRatio_x*2,0)) +
						tex2D(colourMap0,inTex1+float2(-g_pixelRatio_x*4,0)) +
						tex2D(colourMap0,inTex1+float2(-g_pixelRatio_x*6,0))) / 7.0;

	return inColour * finalShade;
}

////////////////////////////////////////////////////////////

technique tech_glowblur_11_20
{
	pass P0
	{
		VertexShader = NULL;	
		PixelShader = compile ps_2_0 ps_glowblur();
	}
}

technique tech_glowblur_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_glowblur();	
	}
}